import java.util.concurrent.*;

public class SubmitCallable {
    public static void main(String arg[]){
        ExecutorService executorService = Executors.newSingleThreadExecutor();

        Future future =executorService.submit(newCallable(" Task")); //not blocked

        System.out.println(future.isDone());
        try {
            String msg =  (String) future.get(); //blocked
            System.out.println(msg);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        } catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        System.out.println(future.isDone());

        executorService.shutdown();
    }
    private  static Callable newCallable(String msg){
        return new Callable() {
            @Override
            public Object call() throws Exception {
                String report = Thread.currentThread().getName()+" :"+msg;

                return report;
            }
        };
        }
}

