import java.util.concurrent.*;

public class ThreadPool {
    public static void main(String[] args) {
        int core = 10;
        int max = 20;
        long keepAlive = 3000;
        ExecutorService executorService = new ThreadPoolExecutor(
                core,
                max,
                keepAlive,
                TimeUnit.MILLISECONDS,
                new ArrayBlockingQueue<>(1000));
        for (int i = 0; i < 1000; i++) {

            executorService.execute(newRunnable(" " + i));
        }
        executorService.shutdown();

    }

    private static Runnable newRunnable(String msg) {
        return new Runnable() {
            @Override
            public void run() {
                String report = Thread.currentThread().getName() + " :" + msg;
                System.out.println(report);
            }
        };
    }

}
