import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

import okhttp3.*;

public class RestApiLoadTester {

    public static void main(String[] args){
//        String url = "http://172.29.3.203:30152/hello/fib/30";

        String url = "http://localhost:8080/test";
        String headers = "content-type: application/json\n" +
                "user-agent: Mozilla/5.0";
        int threadCount = 10;
        int callCountPerThread = 2;

        RestApiLoadTester.runLoadTest(url, headers, threadCount,callCountPerThread);
    }

    public static void runLoadTest(String url, String headers, int threadCount, int callCountPerThread) {
        OkHttpClient httpClient = new OkHttpClient();
//        MediaType mediaType = MediaType.parse("application/json");

        ExecutorService executor = Executors.newFixedThreadPool(threadCount);

        for (int i = 0; i < threadCount; i++) {
            executor.submit(() -> {
                for (int j = 0; j < callCountPerThread; j++) {
                    Request.Builder requestBuilder = new Request.Builder()
                            .url(url);

                    // add headers
                    for (String header : headers.split("\n")) {
                        String[] headerParts = header.split(": ");
                        requestBuilder.addHeader(headerParts[0], headerParts[1]);
                    }

                    // add request body
//                    RequestBody requestBodyObj = RequestBody.create(requestBody, mediaType);

                    Request request = requestBuilder
//                            .post(requestBodyObj)
                            .build();

                    try {
                        Response response = httpClient.newCall(request).execute();
                        System.out.println(response.body().string());
                        response.body().close();
                    } catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
        }

        executor.shutdown();
    }
}