import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class InvokeAny {

    public static void main(String[] args) {

        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Set<Callable<String>> callables = new HashSet<Callable<String>>();

        callables.add(new Callable<String>() {
            public String call() throws Exception {
                return Thread.currentThread().getName()+" Task 1";
            }
        });
        callables.add(new Callable<String>() {
            public String call() throws Exception {
                return Thread.currentThread().getName()+" Task 2";
            }
        });
        callables.add(new Callable<String>() {
            public String call() throws Exception {
                return Thread.currentThread().getName()+" Task 3";
            }
        });


        try {
            String result = executorService.invokeAny(callables); //Once of task is fully executed the other waiting task will get canceled
            System.out.println(result);

        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        } catch (ExecutionException e) {
            throw new RuntimeException(e);
        }


        executorService.shutdown();
    }
}
