import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.*;

public class InvokeAll {

    public static void main(String[] args) {

        // Use a try-with-resources statement for the ExecutorService
        // if you are using Java 19 or later.
        // For earlier versions, a try-finally block is a good practice.
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        try {
            Set<Callable<String>> callables = new HashSet<>();

            // Use lambda expressions for concise callable implementations
            callables.add(() -> Thread.currentThread().getName() + " Task 1");
            callables.add(() -> Thread.currentThread().getName() + " Task 2");
            callables.add(() -> Thread.currentThread().getName() + " Task 3");

            // invokeAll blocks until all tasks are complete
            List<Future<String>> futures = executorService.invokeAll(callables);

            for (Future<String> future : futures) {
                try {
                    // get() will not block here because invokeAll has already completed.
                    System.out.println(future.get());
                } catch (ExecutionException e) {
                    // This is where exceptions from the callables are thrown
                    e.printStackTrace();
                }
            }
        } catch (InterruptedException e) {
            // This is thrown if the thread is interrupted while waiting on invokeAll
            Thread.currentThread().interrupt();
            e.printStackTrace();
        } finally {
            executorService.shutdown();
        }
    }
}
