package com.grpc.server;

import com.grpc.GreeterGrpc;
import com.grpc.HelloReply;
import com.grpc.HelloRequest;
import io.grpc.stub.StreamObserver;
import org.lognet.springboot.grpc.GRpcService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;



@GRpcService
public class Server extends GreeterGrpc.GreeterImplBase {

    Logger logger = LoggerFactory.getLogger(Server.class);
    @Override
    public void sayHello(HelloRequest request, StreamObserver<HelloReply> responseObserver) {
        logger.info("request is: {}", request.getName());
        HelloReply reply = HelloReply.newBuilder().setMessage("Hello " + request.getName()).build();
        responseObserver.onNext(reply);
        responseObserver.onCompleted();
    }
}
