package org.ds;


import org.apache.zookeeper.*;
import org.apache.zookeeper.data.Stat;

import java.io.IOException;
import java.util.Collections;
import java.util.List;

public class Locks implements Watcher {

    private static final String ADDRESS = "172.29.3.101:2181";
    private static final int SESSION_TIMEOUT = 3000;
    private static final String LOCKS = "/locks";
    private String myCandidate;
    private ZooKeeper zooKeeper;

    public static void main(String[] args) throws IOException, InterruptedException, KeeperException {

        Locks locks = new Locks();
        locks.connectToZookeeper();

        locks.CheckLock();
        locks.getLockOrWait();

        locks.run();
        locks.close();
    }

    private void CheckLock() throws KeeperException, InterruptedException {
        if (zooKeeper.exists(LOCKS, false) == null) {
            zooKeeper.create(LOCKS, new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        String path = zooKeeper.create(LOCKS + "/" + "lock-", new byte[]{}, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL);
        myCandidate = path.replace(LOCKS + "/", "");
    }

    private void getLockOrWait() throws KeeperException, InterruptedException {
        CheckLock();

        Stat stat = null;
        String predecessor = "";
        while (stat == null) {
            List<String> children = zooKeeper.getChildren(LOCKS, false);
//        System.out.println(children);
            Collections.sort(children);
            if (children.get(0).equals(myCandidate)) {
                System.out.println("I acquired a lock :). will leave it in 10 seconds");
                for (int i = 0; i < 10; i++) {
                    System.out.println("leaving in " + i + "seconds");
                    Thread.sleep(1000);
                }
                zooKeeper.delete(LOCKS + "/" + children.get(0), -1);
            } else {
                System.out.println("i could not acquire a lock. So will wait");
                int predecessorIndex = Collections.binarySearch(children, myCandidate) - 1;
                predecessor = children.get(predecessorIndex);
                    stat = zooKeeper.exists(LOCKS + "/" + predecessor, this);
            }
        }
    }

    public ZooKeeper connectToZookeeper() throws IOException {
        this.zooKeeper = new ZooKeeper(ADDRESS, SESSION_TIMEOUT, this);
        return zooKeeper;
    }

    public void run() throws InterruptedException {
        synchronized (zooKeeper) {
            zooKeeper.wait();
        }
    }

    private void close() throws InterruptedException {
        this.zooKeeper.close();
    }

    @Override
    public void process(WatchedEvent watchedEvent) {
        if (watchedEvent.getType() == Event.EventType.NodeChildrenChanged) {
            try {
                getLockOrWait();
            } catch (KeeperException e) {
                throw new RuntimeException(e);
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

