# Distributed Locking with Apache ZooKeeper

This project demonstrates a simple implementation of distributed locking using Apache ZooKeeper. The `Locks` class provides a mechanism to acquire and release locks in a distributed environment.

## Table of Contents

- [Overview](#overview)
- [Prerequisites](#prerequisites)
- [Project Structure](#project-structure)
- [How It Works](#how-it-works)
- [Usage](#usage)
- [Dependencies](#dependencies)
- [Running the Project](#running-the-project)
- [Contributing](#contributing)
- [License](#license)

## Overview

Distributed locking is a critical mechanism in distributed systems to ensure that only one process can access a resource at a time. This project uses Apache ZooKeeper, a centralized service for maintaining configuration information, naming, providing distributed synchronization, and providing group services.

## Prerequisites

- Java 17
- Apache Maven
- Apache ZooKeeper (running on `172.29.3.101:2181`)

## Project Structure

```
/src
   /main
      /java
         /org
            /ds
               Locks.java
/pom.xml
README.md
```

- **Locks.java**: The main class that implements the distributed locking mechanism.
- **pom.xml**: Maven configuration file that includes the necessary dependencies.

## How It Works

### Locks.java

The `Locks` class implements the distributed locking mechanism using ZooKeeper. Here's a breakdown of the key methods:

- **connectToZookeeper()**: Connects to the ZooKeeper instance.
- **CheckLock()**: Checks if the `/locks` node exists in ZooKeeper. If not, it creates the node. It then creates an ephemeral sequential node under `/locks`.
- **getLockOrWait()**: Attempts to acquire the lock. If the current node is the smallest in the sequence, it acquires the lock. Otherwise, it waits for the predecessor node to be deleted.
- **run()**: Keeps the ZooKeeper connection alive by waiting on the ZooKeeper instance.
- **close()**: Closes the ZooKeeper connection.
- **process(WatchedEvent watchedEvent)**: Handles events from ZooKeeper, such as node deletion, to retry acquiring the lock.

### Main Execution Flow

1. **Connection**: The `main` method initializes the `Locks` instance and connects to ZooKeeper.
2. **Lock Acquisition**: The `CheckLock` method is called to create the necessary nodes. The `getLockOrWait` method is then called to attempt to acquire the lock.
3. **Lock Holding**: If the lock is acquired, the program holds the lock for 10 seconds and then releases it.
4. **Lock Waiting**: If the lock is not acquired, the program waits for the predecessor node to be deleted.
5. **Cleanup**: The ZooKeeper connection is closed.

## Usage

To use this distributed locking mechanism in your project, follow these steps:

1. **Clone the Repository**:
   ```bash
   git clone <repository-url>
   cd <repository-directory>
   ```

2. **Build the Project**:
   ```bash
   mvn clean install
   ```

3. **Run the Application**:
   ```bash
   java -cp target/DLock-1.0-SNAPSHOT.jar org.ds.Locks
   ```

## Dependencies

The project uses the following dependency:

- **Apache ZooKeeper**: Version 3.9.1

The dependency is managed via Maven and specified in the `pom.xml` file.

## Running the Project

Ensure that ZooKeeper is running on `172.29.3.101:2181`. You can start the ZooKeeper server using the following command:

```bash
zkServer.sh start
```

Then, run the `Locks` class as described in the [Usage](#usage) section.
