package org.ds;


import org.apache.zookeeper.*;

import java.io.IOException;
import java.util.Collections;
import java.util.List;

public class Locks implements Watcher {

    private static final String ADDRESS = "172.29.3.101:2181";
    private static final int SESSION_TIMEOUT = 30000;
    private static final String LOCKS = "/locksM";
    private String myCandidate;
    private ZooKeeper zooKeeper;

    public static void main(String[] args) throws IOException, InterruptedException, KeeperException {

        Locks locks = new Locks();
        locks.connectToZookeeper();

        locks.initLock();
        locks.getLockOrWait();

        locks.run();
        locks.close();
    }

    private void initLock() throws KeeperException, InterruptedException {
        if (zooKeeper.exists(LOCKS, false) == null) {
            zooKeeper.create(LOCKS, new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        String path = zooKeeper.create(LOCKS + "/" + "lock-", new byte[]{}, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL);
        myCandidate = path.replace(LOCKS + "/", "");
        System.out.println("myCandidate " + myCandidate);
    }

    private void getLockOrWait() throws KeeperException, InterruptedException {

        String predecessor = "";
        List<String> children = zooKeeper.getChildren(LOCKS, false);
        System.out.println("List of children " + children);
        Collections.sort(children);
        if (children.get(0).equals(myCandidate)) {
            System.out.println("I acquired a lock :). will leave it in 10 seconds");
            for (int i = 0; i < 10; i++) {
                System.out.println("leaving in " + (10 - i) + "seconds");
                Thread.sleep(1000);
            }
            zooKeeper.delete(LOCKS + "/" + myCandidate, -1);
        } else {
            System.out.println("i could not acquire a lock. So will wait");
            int predecessorIndex = Collections.binarySearch(children, myCandidate) - 1;
            predecessor = children.get(predecessorIndex);

            //Check Race Condition
            if (zooKeeper.exists(LOCKS + "/" + predecessor, this) == null) {
                getLockOrWait();
            }
        }
    }

    public ZooKeeper connectToZookeeper() throws IOException {
        this.zooKeeper = new ZooKeeper(ADDRESS, SESSION_TIMEOUT, this);
        return zooKeeper;
    }

    public void run() throws InterruptedException {
        synchronized (zooKeeper) {
            zooKeeper.wait();
        }
    }

    private void close() throws InterruptedException {
        this.zooKeeper.close();
    }

    @Override
    public void process(WatchedEvent watchedEvent) {
        if (watchedEvent.getType() == Event.EventType.NodeDeleted) {
            try {
                getLockOrWait();
            } catch (KeeperException e) {
                throw new RuntimeException(e);
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

