﻿using Microsoft.AspNetCore.Mvc;

[ApiController]
[Route("[controller]")]
public class NotificationController : ControllerBase
{
    private readonly IEmailService _emailService;

    public NotificationController(IEmailService emailService)
    {
        _emailService = emailService;
    }

    [HttpPost("send")]
    public async Task<IActionResult> Send()
    {
        await _emailService.SendEmailAsync("hiastskype@gmail.com", "Test", "<b>This is a test email</b>");
        return Ok("Email sent.");
    }
}
