import junit.framework.TestCase;
import org.junit.Test;

import java.util.ArrayList;
import java.util.List;

public class StudentServiceTests extends TestCase {
    @Test
    public void testStudentService(){
        long start = System.currentTimeMillis();
        StudentService studentService = new StudentService();
        Student student = new Student("Mohamad");
        studentService.saveStudent(student);
        long end = System.currentTimeMillis() - start;
        System.out.println(end);
    }


    @Test
    public void testMultiStudentService(){
        StudentService studentService = new StudentService();
        long start = System.currentTimeMillis();
        List<StudentServiceThread> threads = new ArrayList<StudentServiceThread>();
        for (int i = 0; i <10 ; i++) {
            StudentServiceThread thread = new StudentServiceThread(studentService,new Student(""+i));
            thread.start();
            threads.add(thread);
        }
        for (Thread thread : threads) {
            try {
                thread.join();
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        long end = System.currentTimeMillis() - start;
        System.out.println(end);

    }
}
