package com.search.lucene.engine.builder.implementations;

import com.search.lucene.engine.abstractions.ISearchEngine;
import com.search.lucene.engine.builder.abstractions.IEngineBuilder;
import com.search.lucene.engine.implementations.LuceneEngine;
import com.search.lucene.indexers.abstractions.IFileIndexer;
import com.search.lucene.indexers.implementations.CSVFileIndexer;
import com.search.lucene.indexers.implementations.PDFFileIndexer;
import com.search.lucene.indexers.implementations.TextFileIndexer;
import com.search.lucene.searchers.abstractions.ISearcher;

import com.search.lucene.searchers.implementations.IndexedDocumentSearcher;
import com.search.lucene.settings.Constants;
import com.search.lucene.settings.IndexPaths;

import java.io.IOException;
import java.util.ArrayList;

public class LuceneEngineBuilder implements IEngineBuilder {
    @Override
    public ISearchEngine build() throws IOException {

        ArrayList<IFileIndexer> indexers = new ArrayList<>();
        indexers.add(new CSVFileIndexer(IndexPaths.CSV_INDEX_FOLDER_PATH));
        indexers.add(new PDFFileIndexer(IndexPaths.PDF_INDEX_FOLDER_PATH));
        indexers.add(new TextFileIndexer(IndexPaths.TEXT_INDEX_FOLDER_PATH));

        ArrayList<ISearcher> searchers = new ArrayList<>();
        searchers.add(new IndexedDocumentSearcher(IndexPaths.CSV_INDEX_FOLDER_PATH, Constants.VALUE));
        searchers.add(new IndexedDocumentSearcher(IndexPaths.PDF_INDEX_FOLDER_PATH,Constants.CONTENT));
        searchers.add(new IndexedDocumentSearcher(IndexPaths.TEXT_INDEX_FOLDER_PATH,Constants.CONTENT));

        return new LuceneEngine(indexers,searchers);
    }
}
