package com.search.lucene.documents.representers.implementations;

import com.search.lucene.documents.representers.abstractions.IDocumentRepresenter;
import com.search.lucene.settings.Constants;
import com.search.lucene.settings.RepresentationSchema;
import org.apache.lucene.document.Document;

public class TextDocumentStringRepresenter implements IDocumentRepresenter<String> {
    @Override
    public String Represent(Document indexedDocument) {
        return String.format("""
                        file path =  %s\s
                        file name =  %s\s
                        with content =  %s\s
                        """,
                indexedDocument.get(Constants.FILE_PATH),
                indexedDocument.get(Constants.FILE_NAME),
                indexedDocument.get(Constants.CONTENT));
    }

    @Override
    public String representationSchema() {
        return RepresentationSchema.TEXT;
    }
}
