package com.search.lucene.documents.representers.implementations;

import com.search.lucene.documents.representers.abstractions.IDocumentRepresenter;
import com.search.lucene.settings.Constants;
import com.search.lucene.settings.RepresentationSchema;
import org.apache.lucene.document.Document;

public class CSVDocumentStringRepresenter implements IDocumentRepresenter<String> {
    @Override
    public String Represent(Document indexedDocument) {
        return String.format("""
                        file path is  %s\s
                        file name is  %s\s
                        row number is  %s\s
                        column name is  %s\s
                        content is  %s\s
                        csv row is  %s\s
                        """,
                indexedDocument.get(Constants.FILE_PATH),
                indexedDocument.get(Constants.FILE_NAME),
                indexedDocument.get(Constants.ROW),
                indexedDocument.get(Constants.COLUMN),
                indexedDocument.get(Constants.VALUE),
                indexedDocument.get(Constants.CSV_ROW));
    }

    @Override
    public String representationSchema() {
        return RepresentationSchema.CSV;
    }
}
