package com.search.lucene;

import java.io.IOException;
import java.util.ArrayList;

import com.search.lucene.documents.representers.resolver.DocumentToStringRepresenterResolver;
import com.search.lucene.documents.representers.resolver.IDocumentRepresenterResolver;
import com.search.lucene.engine.abstractions.ISearchEngine;
import com.search.lucene.engine.builder.abstractions.IEngineBuilder;
import com.search.lucene.engine.builder.implementations.LuceneEngineBuilder;
import com.search.lucene.indexers.implementations.TextFileIndexer;
import com.search.lucene.performance.Benchmarker;
import com.search.lucene.searchers.implementations.IndexedDocumentSearcher;
import com.search.lucene.settings.Constants;
import org.apache.lucene.document.Document;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;

public class Lucene {

    public static void main(String[] args) throws Exception {
        IEngineBuilder builder = new LuceneEngineBuilder();
        ISearchEngine searchEngine = builder.build();

        Benchmarker.benchmark(() -> {
            searchEngine.createIndexesForDirectory("data");
        });


        ArrayList<Document> results = searchEngine.search("Julien Leclercq");
        IDocumentRepresenterResolver<String> resolver = new DocumentToStringRepresenterResolver();
        System.out.println();
        for (var result : results) {
            System.out.println(resolver.resolveRepresentation(result));
        }
    }


//    private static final String indexDir = "index";
//    private static final String dataDir = "data";
//    private static TextFileIndexer indexer;
//    private static IndexedDocumentSearcher textFileSearcher;
//
//    public static void main(String[] args) {
//        try {
//            createIndex();
//            search("Kota");
//            search("s");
//        } catch (IOException e) {
//            e.printStackTrace();
//        } catch (ParseException e) {
//            e.printStackTrace();
//        }
//    }
//
//    private static void createIndex() throws IOException {
//        indexer = new TextFileIndexer(indexDir);
//        int numIndexed;
//        long startTime = System.currentTimeMillis();
//        numIndexed = indexer.createIndex(dataDir);
//        long endTime = System.currentTimeMillis();
//        indexer.close();
//        System.out.println(numIndexed+" File indexed, time taken: "
//                +(endTime-startTime)+" ms");
//    }
//
//    private static void search(String searchQuery) throws IOException, ParseException {
//        textFileSearcher = new IndexedDocumentSearcher(indexDir,Constants.CONTENT);
//        long startTime = System.currentTimeMillis();
//        TopDocs hits = textFileSearcher.search(searchQuery);
//        long endTime = System.currentTimeMillis();
//
//        System.out.println(hits.totalHits +
//                " documents found. Time :" + (endTime - startTime));
//        for(ScoreDoc scoreDoc : hits.scoreDocs) {
//            Document doc = textFileSearcher.getDocument(scoreDoc);
//            System.out.println("File: "
//                    + doc.get(Constants.FILE_PATH));
//        }
//    }
}
