package com.search.lucene.performance;

import java.util.concurrent.Callable;
import java.util.function.Function;

public class Benchmarker {

    public static  <T> T  benchmark(Callable<T> callable) throws Exception {
        long startTime = System.currentTimeMillis();
        T t = callable.call();
        long endTime = System.currentTimeMillis();
        long time = endTime - startTime;
        System.out.println("The Function " + callable.getClass().getName() + " takes " + time +" ms");
        return t;
    }
    public static  void benchmark(RunnableTask callable) throws Exception {
        long startTime = System.currentTimeMillis();
        callable.run();
        long endTime = System.currentTimeMillis();
        long time = endTime - startTime;
        System.out.println("The Function " + callable.getClass().getName() + " takes " + time +" ms");
    }
}
