package com.search.lucene.analyzers;

import com.search.lucene.settings.Constants;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class LuceneAnalyzer {
    public static List<String> analyze(Analyzer analyzer, String text)
            throws IOException {
        List<String> tokens = new ArrayList<>();
        TokenStream tokenStream = analyzer.tokenStream(Constants.DESCRIPTION, text);
        CharTermAttribute attr = tokenStream.addAttribute(CharTermAttribute.class);
        tokenStream.reset();
        while (tokenStream.incrementToken()) {
            tokens.add(attr.toString());
        }
        return tokens;
    }
}
