package com.search.lucene.analyzers;

import com.search.lucene.settings.Constants;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.analysis.en.EnglishAnalyzer;
import org.apache.lucene.analysis.miscellaneous.PerFieldAnalyzerWrapper;
import org.apache.lucene.analysis.standard.StandardAnalyzer;

import java.util.HashMap;
import java.util.Map;

public class CustomAnalyzerWrapperBuilder {
    public PerFieldAnalyzerWrapper build() {
        Map<String, Analyzer> map = new HashMap<>();

        map.put(Constants.ID, new KeywordAnalyzer());
        map.put(Constants.FILE_PATH, new KeywordAnalyzer());
        map.put(Constants.FILE_NAME, new KeywordAnalyzer());

        map.put(Constants.CONTENT, new EnglishAnalyzer());
        map.put(Constants.DESCRIPTION, new EnglishAnalyzer());

        return new PerFieldAnalyzerWrapper(new StandardAnalyzer(),map);
    }

}
