package com.search.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import com.search.lucene.analyzers.LuceneAnalyzer;
import com.search.lucene.documents.representers.resolver.DocumentToStringRepresenterResolver;
import com.search.lucene.documents.representers.resolver.IDocumentRepresenterResolver;
import com.search.lucene.engine.abstractions.ISearchEngine;
import com.search.lucene.engine.builder.abstractions.IEngineBuilder;
import com.search.lucene.engine.builder.implementations.LuceneEngineBuilder;
import com.search.lucene.indexers.implementations.TextFileIndexer;
import com.search.lucene.performance.Benchmarker;
import com.search.lucene.searchers.implementations.IndexedDocumentSearcher;
import com.search.lucene.settings.Constants;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.*;
import org.apache.lucene.analysis.custom.CustomAnalyzer;
import org.apache.lucene.analysis.en.EnglishAnalyzer;
import org.apache.lucene.analysis.en.PorterStemFilterFactory;
import org.apache.lucene.analysis.miscellaneous.CapitalizationFilterFactory;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.analysis.standard.StandardTokenizerFactory;
import org.apache.lucene.document.Document;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;

public class Lucene {

    public static void main(String[] args) throws Exception {
        testAnalyzers();
    }

    private static void testAnalyzers() {
        try {

            String text = "some text from a good man";

            StandardAnalyzer standardAnalyzer = new StandardAnalyzer();
            List<String> tokens = LuceneAnalyzer.analyze(standardAnalyzer, text);
            System.out.println(standardAnalyzer.getClass().getName() + " :");
            tokens.forEach(System.out::println);


            SimpleAnalyzer simpleAnalyzer = new SimpleAnalyzer();
            List<String> simpleTokens = LuceneAnalyzer.analyze(simpleAnalyzer, text);
            System.out.println(simpleAnalyzer.getClass().getName() + " :");
            simpleTokens.forEach(System.out::println);

            WhitespaceAnalyzer whitespaceAnalyzer = new WhitespaceAnalyzer();
            List<String> whiteSpaceTokens = LuceneAnalyzer.analyze(whitespaceAnalyzer, text);
            System.out.println(whitespaceAnalyzer.getClass().getName() + " :");
            whiteSpaceTokens.forEach(System.out::println);

            KeywordAnalyzer keywordAnalyzer = new KeywordAnalyzer();
            List<String> keywordTokens = LuceneAnalyzer.analyze(keywordAnalyzer, text);

            System.out.println(keywordAnalyzer.getClass().getName() + " :");
            keywordTokens.forEach(System.out::println);

            EnglishAnalyzer englishAnalyzer = new EnglishAnalyzer();
            List<String> englishTokens = LuceneAnalyzer.analyze(englishAnalyzer, text);
            System.out.println(englishAnalyzer.getClass().getName() + " :");
            englishTokens.forEach(System.out::println);


            Analyzer customAnalyzer = CustomAnalyzer.builder()
                    .withTokenizer(StandardTokenizerFactory.NAME)
                    .addTokenFilter(LowerCaseFilterFactory.NAME)
                    .addTokenFilter(StopFilterFactory.NAME)
                    .addTokenFilter(PorterStemFilterFactory.NAME)
                    .addTokenFilter(CapitalizationFilterFactory.NAME)
                    .build();
            List<String> customTokens = LuceneAnalyzer.analyze(customAnalyzer, text);

            System.out.println(customAnalyzer.getClass().getName() + " :");
            customTokens.forEach(System.out::println);

        } catch (IOException e) {
            System.out.println(e.getMessage());
        }
    }


}
