package com.search.lucene.documents.representers.resolver;

import com.search.lucene.documents.representers.abstractions.IDocumentRepresenter;
import com.search.lucene.documents.representers.implementations.CSVDocumentStringRepresenter;
import com.search.lucene.documents.representers.implementations.PDFDocumentStringRepresenter;
import com.search.lucene.documents.representers.implementations.TextDocumentStringRepresenter;
import com.search.lucene.settings.RepresentationSchema;
import org.apache.lucene.document.Document;

import java.util.HashMap;

public class DocumentToStringRepresenterResolver implements IDocumentRepresenterResolver<String>{
    private  final HashMap<String,IDocumentRepresenter<String>> hashMap;

    public DocumentToStringRepresenterResolver() {
        hashMap = new HashMap<>();
        hashMap.put(RepresentationSchema.CSV,new CSVDocumentStringRepresenter());
        hashMap.put(RepresentationSchema.TEXT,new TextDocumentStringRepresenter());
        hashMap.put(RepresentationSchema.PDF,new PDFDocumentStringRepresenter());

    }

    public String resolveRepresentation(Document document) {
        return hashMap.get(document.get(RepresentationSchema.TYPE)).Represent(document);
    }
}
