package primeNumbers.implementation;

import primeNumbers.abstractions.IPrimeNumbersExtractor;

import java.util.ArrayList;
import java.util.Collection;

public class ParallelPrimeNumbersExtractor implements IPrimeNumbersExtractor {
    private final int _numberOfThreads;

    // https://www.primesfordays.com/api/primes/nth/555/ for testing purposes
    public ParallelPrimeNumbersExtractor(int numberOfThreads) {
        _numberOfThreads = numberOfThreads;
    }

    @Override
    public Collection<Integer> extract(int start, int end) {
        Collection<Integer> result = new ArrayList<>();
        Collection<Thread> threads = new ArrayList<>();
        Collection<RunnablePrimeNumbersExtractor> extractors = new ArrayList<>();
        System.out.println(_numberOfThreads + " threads launched");
        int base = start;
        int last =  0;
        int range = (end - start) /_numberOfThreads;
        for(int i = 0; i < _numberOfThreads; i++) {
            if(i == _numberOfThreads - 1) {
                last = end;
            }
            else{
                last = base+range;
            }
            RunnablePrimeNumbersExtractor extractor = new RunnablePrimeNumbersExtractor(base,last);
            Thread thread = new Thread(extractor);
            base = base+range+1;
            thread.start();
            extractors.add(extractor);
            threads.add(thread);
        }

        for (Thread thread : threads) {
            try {
                thread.join();
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        for (RunnablePrimeNumbersExtractor extractor : extractors) {
            result.addAll(extractor.get_primeNumbers());
        }
        return result;
    }
}
