package fibonacciSeries.implementation.range;

import fibonacciSeries.abstractions.IFibonacciRangeCalculator;
import fibonacciSeries.utilities.FibonacciStructure;
import fibonacciSeries.utilities.FibonacciStructureService;
import fibonacciSeries.utilities.IFibonacciStructureService;

import java.util.ArrayList;
import java.util.List;

public class FibonacciRangeCalculatorUsingStructure implements IFibonacciRangeCalculator {
    private final FibonacciStructure _fZeroOfTheRange;
    private final FibonacciStructure _fOneOfTheRange;

    public FibonacciRangeCalculatorUsingStructure(FibonacciStructure _fZeroOfTheRange, FibonacciStructure _fOneOfTheRange) {
        this._fZeroOfTheRange = _fZeroOfTheRange;
        this._fOneOfTheRange = _fOneOfTheRange;
    }

    @Override
    public List<FibonacciStructure> calculate(long start, long end) {
        IFibonacciStructureService service = new FibonacciStructureService();
        List<FibonacciStructure> result = new ArrayList<>();

        FibonacciStructure first = _fZeroOfTheRange;
        FibonacciStructure second = _fOneOfTheRange;

        for(long i = start; i < end; i++) {
            FibonacciStructure pushed = service.add(first, second);
            result.add(pushed);
            first = second;
            second = pushed;
        }
        return result;
    }
}
