package fibonacci_series.utilities;

import fibonacci_series.abstractions.IFibonacciRangeCalculator;

public class RunnableFibonacciRangeCalculator implements Runnable{
    private IFibonacciRangeCalculator _rangeCalculator;
    private Long _start;
    private Long _end;

    public IFibonacciRangeCalculator getRangeCalculator() {
        return _rangeCalculator;
    }

    public Long getStart() {
        return _start;
    }

    public Long getEnd() {
        return _end;
    }

    public RunnableFibonacciRangeCalculator(IFibonacciRangeCalculator rangeCalculator, Long start, Long end) {
        _end = end;
        _start = start;
        _rangeCalculator = rangeCalculator;
    }

    @Override
    public void run() {
        _rangeCalculator.calculate(_start, _end);
    }
}
