package fibonacci_series.implementation.range;

import fibonacci_series.abstractions.IFibonacciRangeCalculator;
import fibonacci_series.utilities.FibonacciStructure;
import fibonacci_series.utilities.FibonacciStructureService;
import fibonacci_series.utilities.IFibonacciStructureService;

import java.util.ArrayList;
import java.util.List;

public class FibonacciRangeCalculatorUsingStructure implements IFibonacciRangeCalculator {
    private final FibonacciStructure _fZeroOfTheRange;
    private final FibonacciStructure _fOneOfTheRange;
    private List<FibonacciStructure> _result;

    @Override
    public List<FibonacciStructure> getResult() {
        return _result;
    }

    public FibonacciRangeCalculatorUsingStructure(FibonacciStructure _fZeroOfTheRange, FibonacciStructure _fOneOfTheRange) {
        this._fZeroOfTheRange = _fZeroOfTheRange;
        this._fOneOfTheRange = _fOneOfTheRange;
    }

    @Override
    public List<FibonacciStructure> calculate(long start, long end) {
        IFibonacciStructureService service = new FibonacciStructureService();
        List<FibonacciStructure> result = new ArrayList<>();

        FibonacciStructure first = _fZeroOfTheRange;
        FibonacciStructure second = _fOneOfTheRange;

        for (long i = start; i < end; i++) {
            FibonacciStructure pushed = service.add(first, second);
            result.add(pushed);
            first = second;
            second = pushed;
        }
        _result = result;
        return result;
    }
}
