package primeNumbers.implementation;

import java.util.ArrayList;
import java.util.Collection;

class RunnablePrimeNumbersExtractor implements Runnable {
    private final int _start;
    private final int _end;
    private Collection<Integer> _primeNumbers;

    public Collection<Integer> get_primeNumbers() {
        return _primeNumbers;
    }

    public RunnablePrimeNumbersExtractor(int start, int end) {
        _start = start;
        _end = end;
        _primeNumbers = new ArrayList<>();
    }

    @Override
    public void run() {
        for (int i = _start; i < _end; i++) {
//            System.out.println("from " + _start + " to " +_end);
            boolean isPrime = true;
            for (int j = 2; j < Math.sqrt(i); j++) {
                if (i % j == 0) {
                    isPrime = false;
                    break;
                }
            }
            if(isPrime) {
                _primeNumbers.add(i);
            }
        }
//        System.out.println("Thread finished " + this._start + ", "+ this._end);
    }
}
