package fibonacci_series.runners;

import fibonacci_series.abstractions.IFibonacciRangeCalculator;
import fibonacci_series.implementation.range.FibonacciRangeCalculatorUsingStructure;
import fibonacci_series.utilities.FibonacciStructure;

import java.util.List;

public class Main {
    public static void main(String[] args) {
//        IFibonacciCalculator calculator = new MathFibonacciCalculator();
//        for (int i = 0; i < 10; i++) {
//            System.out.println("F("+i+") = "+calculator.calculate(i));
//        }
        FibonacciStructure first = new FibonacciStructure(1l,0l);
        FibonacciStructure second = new FibonacciStructure(0l,1l);
        IFibonacciRangeCalculator rangeCalculator =
                new FibonacciRangeCalculatorUsingStructure(first,second);
        List<FibonacciStructure> result = rangeCalculator.calculate(2,40);
        for(FibonacciStructure structure : result){
            System.out.println(structure.getFibonacciValue(0,1));
        }
    }
}
