package tokenization_test

import (
	Settings "donut/settings"
	Tokenizer "donut/tokenization"
	"testing"
)

func TestExtractDirectiveContent_ShouldReturnTheExpectedResult_WhenTheTemplateContainsNewLinesBetweenDirectives(t *testing.T) {
	template :=
		`
		@template {{ some code.... }}

		@exec {{ some go code.... }}
		@imports {{ "tesing_package" }}
		@template {{ some code.... }}
		
		@exec {{ some go code.... }}
		`
	expectedImports := ` "tesing_package" `
	expectedTemplate :=
		`
		@template {{ some code.... }}

		@exec {{ some go code.... }}
		
		@template {{ some code.... }}
		
		@exec {{ some go code.... }}
		`

	result := Tokenizer.ExtractDirectiveContent(template, Settings.IMPORT_KEY_WORD)

	if result[0] != expectedImports {
		t.Error("error in getting imports")
	}
	if result[1] != expectedTemplate {
		t.Error("error in getting template")
	}
}

func TestExtractDirectiveContent_ShouldReturnTheExpectedResult_WhenTheTemplateContainsSpacesBetweenDirectives(t *testing.T) {
	template :=
		`
	@template {{ some code.... }} @exec {{ some go code.... }} @imports {{"tesing_package" }} @template {{ some code.... }} @exec {{ some go code.... }}
	`
	expectedImports := `"tesing_package" `
	expectedTemplate :=
		`
	@template {{ some code.... }} @exec {{ some go code.... }}  @template {{ some code.... }} @exec {{ some go code.... }}
	`
	result := Tokenizer.ExtractDirectiveContent(template, Settings.IMPORT_KEY_WORD)

	if result[0] != expectedImports {
		t.Error("error in getting imports")
	}
	if result[1] != expectedTemplate {
		t.Error("error in getting template")
	}
}

func TestExtractDirectiveContent_ShouldReturnTheExpectedResult_WhenTheTemplateStacksDirectivesWithNoSpaces(t *testing.T) {
	template :=
		`
	@template {{ some code.... }}@exec {{ some go code.... }}54646@imports{{  8  "tesing_package"}}@template{{ some code.... }}@exec{{ some go code.... }}
	`
	expectedImports := `  8  "tesing_package"`
	expectedTemplate :=
		`
	@template {{ some code.... }}@exec {{ some go code.... }}54646@template{{ some code.... }}@exec{{ some go code.... }}
	`
	result := Tokenizer.ExtractDirectiveContent(template, Settings.IMPORT_KEY_WORD)

	if result[0] != expectedImports {
		t.Error("error in getting imports")
	}
	if result[1] != expectedTemplate {
		t.Error("error in getting template")
		t.Log(result[1])
	}
}
