package Tokenizer

import (
	Types "donut/types"
)

func ConvertNestingToConcatenation(startAt int, template string, executeToken string, templateToken string) Types.RecursionResult {

	/*
	 * the answer is the string where we will save the mutated template
	 */

	answer := ""

	/*
	 * the termination index will contain the index where the prosses terminated
	 */
	terminationIndex := len(template)

	/*
	 * loop over the template from the parameter @startingIndex
	 * the end of the scope which is where the nesting scope end
	 */
	for index := startAt; index < len(template); {

		/*
		 * adding the characher to the template
		 */
		answer = answer + string(template[index])

		/**
		 * increment the index because we handle this charachter
		 */
		index++

		/**
		 * start handling the nesting
		 */
		if template[index-1] == '@' {

			/**
			* case of templateToken scope
			 */
			if template[index:index+len(templateToken)] == templateToken {

				/**
				* adding the templateToken after the @ so that the template will not change
				 */
				answer = answer + templateToken

				/**
				* jump to the index after the templateToken
				 */
				index = index + len(templateToken)

				/**
				* the index where the templateToken scope end
				 */
				terminationIndex = FindTerminationIndex(template, index)

				/**
				* start proccessing the inner scope
				 */
				for idx := index; idx < terminationIndex; {

					/**
					* if we found a nested scope we will recursively handle it
					 */
					if template[idx] == '@' {

						/**
						* get the result of the recursive function
						 */
						next := ConvertNestingToConcatenation(idx, template, executeToken, templateToken)

						/**
						* jump to the terminated index of the inner nested block
						 */
						idx = next.TerminatedAt

						/**
						* update the answer to concate the result of the inner nested block
						 */
						answer = answer + "}" + "}" + next.Template + "@" + templateToken + "{" + "{"
					} else {

						/**
						* add the character directly because the is no nesting
						 */
						answer = answer + string(template[idx])

						/**
						* increament the loop index
						 */
						idx++
					}

				}

				/**
				* terminate the process
				 */
				index = terminationIndex
				break
			}

			/**
			* case of executeToken scope
			 */
			if template[index:index+len(executeToken)] == executeToken {

				/**
				* adding the executeToken after the @ so that the template will not change
				 */
				answer = answer + executeToken

				/**
				* jump to the index after the executeToken
				 */
				index = index + len(executeToken)

				/**
				* the index where the executeToken scope end
				 */
				terminationIndex = FindTerminationIndex(template, index)

				/**
				* start proccessing the inner scope
				 */
				for idx := index; idx < terminationIndex; {

					/**
					* if we found a nested scope we will recursively handle it
					 */
					if template[idx] == '@' {

						/**
						* get the result of the recursive function
						 */
						next := ConvertNestingToConcatenation(idx, template, executeToken, templateToken)

						/**
						* jump to the terminated index of the inner nested block
						 */
						idx = next.TerminatedAt

						/**
						* update the answer to concate the result of the inner nested block
						 */
						answer = answer + "}" + "}" + next.Template + "@" + executeToken + "{" + "{"
					} else {

						/**
						* add the character directly because the is no nesting
						 */
						answer = answer + string(template[idx])

						/**
						* increament the loop index
						 */
						idx++
					}
				}

				/**
				* terminate the process
				 */
				index = terminationIndex
				break
			}

		}

	}
	return Types.RecursionResult{Template: answer, TerminatedAt: terminationIndex}
}
