package FileManagement

import (
	"bufio"
	"log"
	"os"
)

/**
 * reads file data and returns it as a string
 */
func ReadData(fileName string) string {

	file, err := os.Open(fileName)
	if err != nil {
		log.Fatal(err)
	}
	defer file.Close()
	data := ""
	scanner := bufio.NewScanner(file)
	for scanner.Scan() {
		data = data + scanner.Text() + "\n"
	}
	return data
}

/**
 * writes text data to a file
 */
func WriteFile(filePath string, text string) {
	f, err := os.Create(filePath)
	if err != nil {
		log.Fatal(err)
	}
	defer f.Close()

	_, err = f.WriteString(text)
	if err != nil {
		log.Fatal(err)
	}
}
