package Transpilation

import Tokenizer "donut/tokenization"

type Transpiler struct {
	template string
}

func BuildTranspiler(template string) Transpiler {
	return Transpiler{template: template}
}

func (transpiler Transpiler) GetExecutable() string {
	importsParsingResult := Tokenizer.ExtractDirectiveContent(transpiler.template, "@import")
	transpiler.template = importsParsingResult[1]
	println("transpiler.template")
	println(transpiler.template)
	println("transpiler.template")
	importsContent := importsParsingResult[0]
	println(importsContent)
	defineParsingResult := Tokenizer.ExtractDirectiveContent(transpiler.template, "@define")
	transpiler.template = defineParsingResult[1]
	defineContent := defineParsingResult[0]
	println(defineContent)
	templateAfterAdjustingInjectables := Tokenizer.ReplaceDirectiveContent(transpiler.template, "@inject", returnInjectedString)
	transpiler.template = templateAfterAdjustingInjectables
	println("templateAfterAdjustingInjectables")
	println(templateAfterAdjustingInjectables)
	println("templateAfterAdjustingInjectables")
	resultAfterReplacingNesting := ""
	startingIdx := 0
	for {
		println(startingIdx)
		if startingIdx == len(transpiler.template) {
			break
		}
		res := Tokenizer.ConvertNestingToConcatenation(startingIdx, transpiler.template, "exec", "template")
		startingIdx = res.TerminatedAt
		resultAfterReplacingNesting = resultAfterReplacingNesting + res.Template
	}

	transpiler.template = resultAfterReplacingNesting

	templateSectionsParsed := Tokenizer.ReplaceDirectiveContent(transpiler.template, "@template", returnInjectedtemplate)
	transpiler.template = templateSectionsParsed

	execSectionsParsed := Tokenizer.ReplaceDirectiveContent(transpiler.template, "@exec", returnCode)
	transpiler.template = execSectionsParsed
	finalCode := injectImports(importsContent) + injectMain(transpiler.template) + defineContent
	return finalCode
}

func returnInjectedString(text string) string {
	return "\nCode = Code + string( " + text + " )\n"
}

func returnInjectedtemplate(text string) string {
	return "\nCode = Code + string( `" + text + "`)\n"
}

func returnCode(text string) string {
	return text
}

func injectImports(imports string) string {
	return `
package main
import(
	` + imports + `

)

`
}

func injectMain(main string) string {
	return `
func main() {
	Code := ""

` + main + `

}
`
}
