package Tokenizer

import (
	Types "donut/types"
	"regexp"
)

/*
*

  - gets a template then replace all occurences of it with the fn(its content)
    fn is the transformation that we want to apply to the content of the template
  - returns the updated template
*/
func ReplaceDirectiveContent(template string, directiveName string, fn Types.TextToTextConverter) string {

	/**
	 * regex to find the directive keyword, it will return list of matches
	 * the match is stuctured like this [starting_index,end_index]
	 */
	re := regexp.MustCompile(directiveName)

	/**
	 * the places where the directive keyword found
	 */
	directiveMatches := re.FindAllStringIndex(template, -1)

	/**
	  	* pair of values
		* the first is the content of the directive
		* the second is the index where the directive is terminated
	*/
	var directivesContentSpecification = []Types.DirectiveContentSpecification{}

	/**
	 * loop over the occurences of the directive
	 * gets the directive content specification
	 */
	for _, tuple := range directiveMatches {
		dc := GetDirectiveContentWithTerminationIndex(template[tuple[0]:], directiveName)
		directivesContentSpecification = append(directivesContentSpecification, dc)
	}

	/**
	 * the new template will contain the old one but
	 * we will replace all occurences of the directive with its content
	 * with the function fn
	 */
	newTemplate := ""

	/**
	 * index to add to the new template the old value from this index
	 * to the start of the directive, so that we can accumulate the new template
	 */
	leftIndex := 0

	/**
	 * loop over the occurences of the directive
	 * and construct the new template
	 */
	for index, tuple := range directiveMatches {
		// adding the content before the directive
		newTemplate = newTemplate + template[leftIndex:tuple[0]]

		// adding the transformed content of the directive
		newTemplate = newTemplate + fn(directivesContentSpecification[index].Content)

		// update the leftIndex it will be equal to the index where the directive closed
		leftIndex = directivesContentSpecification[index].TerminationIndex + tuple[0]
	}

	// adding the remaining template which will be the same of the old because there isn't any directive occurence in it
	newTemplate = newTemplate + template[leftIndex:]

	return newTemplate

}
