package Tokenizer

import (
	Types "donut/types"
	"regexp"
)

/*
*
  - gets a template then extract the content of the directive
  - and mutaute it to remove the content of it.
*/
func ExtractDirectiveContent(template string, directiveName string) [2]string {

	/**
	 * regex to find the directive keyword, it will return list of matches
	 * the match is stuctured like this [starting_index,end_index]
	 */
	re := regexp.MustCompile(directiveName)

	/**
	 * the places where the directive keyword found
	 */
	directiveMatches := re.FindAllStringIndex(template, -1)

	/**
	 * the index that we will use to loop over the template
	 */
	loopIndex := 0

	/**
	 * the index of where the start `{{` found
	 */
	indexOfOpenedBracket := 0

	/**
	 * the index of where the start `}}` found
	 */
	directiveFinishedFrom := 0

	/**
	 * loop over the template from the index where we found
	 * the directive keyword until we find the `}}`
	 */

	for loopIndex = directiveMatches[0][0]; loopIndex < len(template); loopIndex++ {

		/**
		 * find `{{` and same its index
		 */
		if template[loopIndex] == '{' && template[loopIndex+1] == '{' {
			indexOfOpenedBracket = loopIndex
		}

		/**
		 * break the loop because we found the temination token
		 */
		if template[loopIndex] == '}' && template[loopIndex+1] == '}' {
			break
		}
	}

	/**
	 * the directive content that will be returned from the function
	 */
	directiveContent := template[indexOfOpenedBracket+2 : loopIndex]

	/**
	 * the index where we finished the parsing of the directive content
	 */
	directiveFinishedFrom = loopIndex + 2

	/**
	 * mutate the template to return the old template but cleaned from the directive content
	 */
	newTemplate := template[:directiveMatches[0][0]] + template[directiveFinishedFrom:]

	return [2]string{directiveContent, newTemplate}
}

/*
*

  - gets a template then extract the content of the directive
  - and returns the index where it ended
*/
func GetDirectiveContentWithTerminationIndex(template string, directiveName string) Types.DirectiveContentSpecification {

	/**
	 * regex to find the directive keyword, it will return list of matches
	 * the match is stuctured like this [starting_index,end_index]
	 */
	re := regexp.MustCompile(directiveName)

	/**
	 * the places where the directive keyword found
	 */
	directiveMatches := re.FindAllStringIndex(template, -1)

	/**
	 * the index that we will use to loop over the template
	 */
	loopIndex := 0

	/**
	 * the index of where the start `{{` found
	 */
	indexOfOpenedBracket := 0

	/**
	 * loop over the template from the index where we found
	 * the directive keyword until we find the `}}`
	 */

	for loopIndex = directiveMatches[0][0]; loopIndex < len(template); loopIndex++ {

		/**
		 * find `{{` and same its index
		 */
		if template[loopIndex] == '{' && template[loopIndex+1] == '{' {
			indexOfOpenedBracket = loopIndex
		}

		/**
		 * break the loop because we found the temination token
		 */
		if template[loopIndex] == '}' && template[loopIndex+1] == '}' {
			break
		}
	}

	/**
	 * the directive content that will be returned from the function
	 */
	directiveContent := template[indexOfOpenedBracket+2 : loopIndex]

	/**
	 * the index where we finished the parsing of the directive content
	 */
	directiveFinishedFrom := loopIndex + 2

	return Types.DirectiveContentSpecification{Content: directiveContent, TerminationIndex: directiveFinishedFrom}
}

func FindTerminationIndex(template string, startingIndex int) int {
	counter := 0
	passed := false
	k := startingIndex
	indexOfClosing := k
	for ; k < len(template); k++ {
		if counter == 0 && passed {
			indexOfClosing = k + 1
			break
		}
		if template[k] == '}' && template[k+1] == '}' {
			passed = true
			counter = counter - 1
		}
		if template[k] == '{' && template[k+1] == '{' {
			passed = true
			counter = counter + 1
		}
	}

	return indexOfClosing
}
