package tokenization_test

import (
	Tokenizer "donut/tokenization"
	"testing"
)

func TestReplaceDirectiveContentWithTemplateWithNewLinesBetweenDirectives(t *testing.T) {
	template :=
		`----
		@template {{ some code.... }}

		@exec {{
			for i := 0; i < 7; i++ { 
			  @inject {{ string(i) }}
			} 
		}}
		
		@template {{ some code.... }}
		
		@exec {{ some go code.... }}
		------
		`
	expectedTemplate :=
		`----
		@template {{ some code.... }}

		@exec {{
			for i := 0; i < 7; i++ { 
			  code =  code +  string(i) 
			} 
		}}
		
		@template {{ some code.... }}
		
		@exec {{ some go code.... }}
		------
		`
	result := Tokenizer.ReplaceDirectiveContent(template, "@inject", Identity)
	t.Log(result)
	if result != expectedTemplate {
		t.Error("error in getting template")
	}
}

func TestReplaceDirectiveContentWithTemplateWithSpacesBetweenDirectives(t *testing.T) {
	template :=
		`----
		@template {{ some code.... }}

		@exec {{
			for i := 0; i < 7; i++ { @inject {{ string(i) }} }
		}}
		
		@template {{ some code.... }}
		
		@exec {{ some go code.... }}
		------
		`
	expectedTemplate :=
		`----
		@template {{ some code.... }}

		@exec {{
			for i := 0; i < 7; i++ { code =  code +  string(i)  }
		}}
		
		@template {{ some code.... }}
		
		@exec {{ some go code.... }}
		------
		`
	result := Tokenizer.ReplaceDirectiveContent(template, "@inject", Identity)
	t.Log(result)
	if result != expectedTemplate {
		t.Error("error in getting template")
	}
}

func Identity(text string) string {
	return "code = " + " code + " + text
}
