package tokenization_test

import (
	// Settings "donut/settings"
	Tokenizer "donut/tokenization"
	"testing"
)

func TestConvertNestingToConcatenation_ShouldReturnTheExpectedResult_WhenTheTemplateContainsNewLinesBetweenDirectives(t *testing.T) {
	template :=
		`
		@template {{ some code.... @exec {{ nothing }} }}

		@exec {{ some go code.... }}
		@imports {{ "tesing_package" }}
		@template {{ some code.... }}
		
		@exec {{ some go code.... }}
		`

	expectedTemplate :=
		`
		@template {{ some code.... }}@exec {{ nothing }}@template{{ }}

		@exec {{ some go code.... }}
		@imports {{ "tesing_package" }}
		@template {{ some code.... }}
		
		@exec {{ some go code.... }}
		`

	new := ""
	startingIdx := 0
	for {
		if startingIdx == len(template) {
			break
		}
		res := Tokenizer.ConvertNestingToConcatenation(startingIdx, template, "exec", "template")
		startingIdx = res.TerminatedAt
		new = new + res.Template
	}
	// t.Log(new)
	if new != expectedTemplate {
		t.Error("error in getting template")
	}
}

func TestConvertNestingToConcatenation_ShouldReturnTheExpectedResult_WhenTheTemplateStacksDirectivesWithNoSpaces(t *testing.T) {
	template :=
		`
		@template {{ some code.... @exec{{nothing}}555@exec{{nothing}} }}@exec {{ some go code.... }}
		@template {{ "tesing_package"@exec{{nothing}} }}
		@template {{ some code.... }}
		
		@exec {{ some go code.... }}
		`

	expectedTemplate :=
		`
		@template {{ some code.... }}@exec{{nothing}}@template{{555}}@exec{{nothing}}@template{{ }}@exec {{ some go code.... }}
		@template {{ "tesing_package"}}@exec{{nothing}}@template{{ }}
		@template {{ some code.... }}
		
		@exec {{ some go code.... }}
		`

	new := ""
	startingIdx := 0
	for {
		if startingIdx == len(template) {
			break
		}
		res := Tokenizer.ConvertNestingToConcatenation(startingIdx, template, "exec", "template")
		startingIdx = res.TerminatedAt
		new = new + res.Template
	}
	t.Log(new)
	if new != expectedTemplate {
		t.Error("error in getting template")
	}
}
