package Presentation

import (
	ChannelsRoutes "data_broker/routes/channels"
	DataRoutes "data_broker/routes/data"

	"github.com/gin-gonic/gin"
)

type RestfulServer struct {
	engine gin.Engine
}

func (server *RestfulServer) Init() {
	server.engine = *gin.Default()
}

func (server *RestfulServer) MapRoutes() {
	server.engine.GET("/channels/:channel", ChannelsRoutes.Pull)
	server.engine.GET("/data/:channel/:key", DataRoutes.Pull)
	server.engine.POST("/data/push", DataRoutes.Push)
}

func (server *RestfulServer) Start(url string) {
	server.engine.Run(url)
}
