package Data

type DataContainer struct {
	data map[string]map[string]string
}

func (container *DataContainer) Init() {
	container.data = make(map[string]map[string]string)
}

func (container *DataContainer) Push(channel string, key string, value string) {
	if container.data[channel] == nil {
		container.data[channel] = make(map[string]string)
	}
	container.data[channel][key] = value
}

func (container *DataContainer) Pull(channel string, key string) string {
	return container.data[channel][key]
}

func (container *DataContainer) Channel(channel string) map[string]string {
	return container.data[channel]
}
