package DataRoutes

import (
	Data "data_broker/data"
	Requests "data_broker/models"
	"net/http"

	"github.com/gin-gonic/gin"
)

func Push(context *gin.Context) {
	var pushDataCommand Requests.PushDataCommand

	if err := context.BindJSON(&pushDataCommand); err != nil {
		return
	}
	var container = Data.DataContainer{}
	container.Init()
	container.Push(pushDataCommand.Channel, pushDataCommand.Key, pushDataCommand.Payload)
	context.IndentedJSON(http.StatusOK, true)
}
