import junit.framework.TestCase;

import java.util.ArrayList;
import java.util.List;

public class SyncListTest extends TestCase {

    public void testAddList() {

        SyncList syncList = new SyncList();

        syncList.add(1);
        syncList.add(2);
        syncList.add(3);
        syncList.add(Integer.MIN_VALUE);
        syncList.add(3);
        System.out.println(syncList.contain(5));
        System.out.println(syncList.contain(2));
        syncList.remove(3);
        syncList.printList();

    }

    public void testRandomGenerator() {
        RandomSequenceGenerator randomSequenceGenerator = new RandomSequenceGenerator(0, 1000);
        for (int i = 0; i < 10; i++) {
            System.out.println(randomSequenceGenerator.next() + " ");
        }
    }

    int randLength = 20_000;

    public void testHelp(SortList sortList, String label) {
        RandomSequenceGenerator randomSeq = new RandomSequenceGenerator(0, 80_000);

        List<Thread> addThreads = new ArrayList<Thread>();
        List<Thread> containThreads = new ArrayList<Thread>();
        List<Thread> removeThreads = new ArrayList<Thread>();

        for (int i = 0; i < 8; i++) {
            AddThread addThread = new AddThread(randomSeq, sortList,randLength/8 );
            ContainThread containThread = new ContainThread(randomSeq, sortList,randLength/8 );
            RemoveThread removeThread = new RemoveThread(randomSeq, sortList,randLength/8 );

            addThreads.add(new Thread(addThread));
            containThreads.add(new Thread(containThread));
            removeThreads.add(new Thread(removeThread));
        }

        long start = System.currentTimeMillis();

        addThreads.stream().forEach(e -> e.start());
        addThreads.stream().forEach(e -> {
            try {
                e.join();
            } catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
        });

        long end = System.currentTimeMillis();

        System.out.println(label + " add execution time: " + (end-start));

        start = System.currentTimeMillis();

        containThreads.stream().forEach(e -> e.start());
        containThreads.stream().forEach(e -> {
            try {
                e.join();
            } catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
        });

        end = System.currentTimeMillis();

        System.out.println(label + " contain execution time: " + (end-start));

        start = System.currentTimeMillis();

        removeThreads.stream().forEach(e -> e.start());
        removeThreads.stream().forEach(e -> {
            try {
                e.join();
            } catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
        });

        end = System.currentTimeMillis();

        System.out.println(label + " remove execution time: " + (end-start));



    }


    public void testRun(){
        SyncList syncList = new SyncList();
        LockList lockList = new LockList();
        RWLockList rwLockList = new RWLockList();

        testHelp(syncList, "Synchronized");
        System.out.println("\n**********************************************************\n");
        testHelp(lockList, "Locked");
        System.out.println("\n**********************************************************\n");
        testHelp(rwLockList, "RWLockList");
    }


}
