import junit.framework.TestCase;
import org.junit.Assert;

import java.util.ArrayList;
import java.util.List;

public class SyncListTest extends TestCase {

    public void testAddList() {

        SyncList syncList = new SyncList();

        syncList.add(1);
        syncList.add(2);
        syncList.add(3);
        syncList.add(Integer.MIN_VALUE);
        syncList.add(3);
        System.out.println(syncList.contain(5));
        System.out.println(syncList.contain(2));
        syncList.remove(3);
        syncList.printList();

    }

    public void testRandomGenerator() {
        RandomSequenceGenerator randomSequenceGenerator = new RandomSequenceGenerator(0, 1000);
        for (int i = 0; i < 10; i++) {
            System.out.println(randomSequenceGenerator.next() + " ");
        }
    }

    int randLength = 20_000;
    int numOfThreads = 8;
    int randNumsRange = 80_000;

    public void testHelp(SortList sortList, String label) {
        RandomSequenceGenerator randomSeq = new RandomSequenceGenerator(0, randNumsRange);

        List<Thread> addThreads = new ArrayList<Thread>();
        List<Thread> containThreads = new ArrayList<Thread>();
        List<Thread> removeThreads = new ArrayList<Thread>();

        for (int i = 0; i < numOfThreads; i++) {
            AddThread addThread = new AddThread(randomSeq, sortList,randLength/numOfThreads);
            ContainThread containThread = new ContainThread(randomSeq, sortList,randLength/numOfThreads);
            RemoveThread removeThread = new RemoveThread(randomSeq, sortList,randLength/numOfThreads);

            addThreads.add(new Thread(addThread));
            containThreads.add(new Thread(containThread));
            removeThreads.add(new Thread(removeThread));
        }

        long start = System.currentTimeMillis();

        addThreads.stream().forEach(e -> e.start());
        addThreads.stream().forEach(e -> {
            try {
                e.join();
            } catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
        });

        long end = System.currentTimeMillis();

        System.out.println(label + " add execution time: " + (end-start));

        // Ensure list is still sorted
        Assert.assertTrue(sortList.isSorted());

        // List length after add operations
        int listLengthAfterAdds = sortList.length;
        System.out.println("List length after add " + listLengthAfterAdds);

        start = System.currentTimeMillis();

        containThreads.stream().forEach(e -> e.start());
        containThreads.stream().forEach(e -> {
            try {
                e.join();
            } catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
        });

        end = System.currentTimeMillis();

        System.out.println(label + " contain execution time: " + (end-start));
        int totalSuccessfulContains = sortList.successfulContains;
        int totalUnsuccessfulContains = sortList.unsuccessfulContains;
        System.out.println("Total number of successes found " + totalSuccessfulContains + ", failures found: " + totalUnsuccessfulContains);

        start = System.currentTimeMillis();

        removeThreads.stream().forEach(e -> e.start());
        removeThreads.stream().forEach(e -> {
            try {
                e.join();
            } catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
        });

        end = System.currentTimeMillis();

        System.out.println(label + " remove execution time: " + (end-start));

        // Ensure list is still sorted
        Assert.assertTrue(sortList.isSorted());

        // List length after remove operations
        int listLengthAfterRemove = sortList.length;
        System.out.println("List length after remove " + listLengthAfterRemove);

        int totalSuccessfulRemoves = sortList.successfulRemoves;
        int totalUnsuccessfulRemoves = sortList.unsuccessfulRemoves;
        System.out.println("Total number of successes removed " + totalSuccessfulRemoves + ", failures found: " + totalUnsuccessfulRemoves);

    }


    public void testWithRemoveAllHelp(RWLockList sortList, String label) {
        RandomSequenceGenerator randomSeq = new RandomSequenceGenerator(0, randNumsRange);

        List<Thread> addThreads = new ArrayList<Thread>();
        List<Thread> containThreads = new ArrayList<Thread>();
        List<Thread> removeThreads = new ArrayList<Thread>();

        for (int i = 0; i < 8; i++) {
            AddThread addThread = new AddThread(randomSeq, sortList,randLength/numOfThreads);
            ContainThread containThread = new ContainThread(randomSeq, sortList,randLength/numOfThreads);
            RemoveAllThread removeAllThread = new RemoveAllThread(randomSeq, sortList,randLength/numOfThreads);

            addThreads.add(new Thread(addThread));
            containThreads.add(new Thread(containThread));
            removeThreads.add(new Thread(removeAllThread));
        }

        long start = System.currentTimeMillis();

        addThreads.stream().forEach(e -> e.start());
        addThreads.stream().forEach(e -> {
            try {
                e.join();
            } catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
        });

        long end = System.currentTimeMillis();

        System.out.println(label + " add execution time: " + (end-start));

        // Ensure list is still sorted
        Assert.assertTrue(sortList.isSorted());

        // List length after add operations
        int listLengthAfterAdds = sortList.length;
        System.out.println("List length after add " + listLengthAfterAdds);

        start = System.currentTimeMillis();

        containThreads.stream().forEach(e -> e.start());
        containThreads.stream().forEach(e -> {
            try {
                e.join();
            } catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
        });

        end = System.currentTimeMillis();

        System.out.println(label + " contain execution time: " + (end-start));
        int totalSuccessfulContains = sortList.successfulContains;
        int totalUnsuccessfulContains = sortList.unsuccessfulContains;
        System.out.println("Total number of successes found " + totalSuccessfulContains + ", failures found: " + totalUnsuccessfulContains);

        start = System.currentTimeMillis();

        removeThreads.stream().forEach(e -> e.start());
        removeThreads.stream().forEach(e -> {
            try {
                e.join();
            } catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
        });

        end = System.currentTimeMillis();

        System.out.println(label + " remove execution time: " + (end-start));

    }


    public void testRun(){
        SyncList syncList = new SyncList();
        LockList lockList = new LockList();
        RWLockList rwLockList = new RWLockList();

        testHelp(syncList, "Synchronized");
        System.out.println("\n**********************************************************\n");
        testHelp(lockList, "Locked");
        System.out.println("\n**********************************************************\n");
        testHelp(rwLockList, "RWLockList");
    }

    public void testWithRemoveAllRun(){
        RWLockList rwLockList = new RWLockList();
        testWithRemoveAllHelp(rwLockList, "RWLockList With Remove All");
    }

}
