import java.util.concurrent.locks.ReentrantReadWriteLock;

public class RWLockList extends SortList {
    ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    ReentrantReadWriteLock successfulContainsLock = new ReentrantReadWriteLock();
    ReentrantReadWriteLock unsuccessfulContainsLock = new ReentrantReadWriteLock();

    public RWLockList() {
        super();
    }

    @Override
    public boolean add(Integer obj) {
        try {
            lock.writeLock().lock();

            Entry prev = this.head;
            Entry curr = prev.next;
            while (curr.object.compareTo(obj) < 0) {
                prev = curr;
                curr = prev.next;
            }
            if (curr.object.equals(obj) || prev.object.equals(obj)) {
                return false;
            } else {
                Entry newEntry = new Entry(obj);
                newEntry.next = curr;
                prev.next = newEntry;
                this.length++;
                return true;
            }
        } finally {
            lock.writeLock().unlock();
        }
    }

    @Override
    public boolean remove(Integer obj) {
        try {
            lock.writeLock().lock();
            Entry prev = this.head;
            Entry curr = prev.next;
            while (curr.object.compareTo(obj) < 0) {
                prev = curr;
                curr = prev.next;
            }
            if (curr.object.equals(obj)) {
                prev.next = curr.next;
                this.length--;
                successfulRemoves++;
                return true;
            } else {
                unsuccessfulRemoves++;
                return false;
            }
        } finally {
            lock.writeLock().unlock();
        }

    }

    @Override
    public boolean contain(Integer obj) {
        try {
            lock.readLock().lock();
            Entry prev = this.head;
            Entry curr = prev.next;
            while (curr.object.compareTo(obj) < 0) {
                prev = curr;
                curr = prev.next;
            }
            if (curr.object.equals(obj) || prev.object.equals(obj)) {
                successfulContainsLock.writeLock().lock();
                successfulContains++;
                successfulContainsLock.writeLock().unlock();
                return true;
            } else {
                unsuccessfulContainsLock.writeLock().lock();
                unsuccessfulContains++;
                unsuccessfulContainsLock.writeLock().unlock();
                return false;
            }
        } finally {
            lock.readLock().unlock();
        }
    }

    public boolean safeRemoveElement(Integer obj){
        Entry prev, curr;

        this.head.lock.readLock().lock();
        prev = this.head;
        prev.next.lock.readLock().lock();
        curr = prev.next;

        while (curr.object.compareTo(obj) < 0) {
            curr.next.lock.readLock().lock();
            prev.lock.readLock().unlock();
            prev = curr;
            curr = prev.next;
        }
            
        prev.lock.readLock().unlock();
        curr.lock.readLock().unlock();

        prev.lock.writeLock().lock();
        curr.lock.writeLock().lock();

        boolean isRemoved;

        if (curr.object.equals(obj)) {
            prev.next = curr.next;
            isRemoved = true;
        } else {
            isRemoved = false;
        }
                
        prev.lock.writeLock().unlock();
        curr.lock.writeLock().unlock();

        return isRemoved;
    }

    public void removeList(Integer[] toRemoveList){
        for(Integer obj:  toRemoveList){
           safeRemoveElement(obj);
        }
    }

}
