package hiast.hw.question3;

import junit.framework.TestCase;

import java.util.HashMap;


public class FibonacciTest extends TestCase {

    int n=50;

    final HashMap<Integer, Long> memo = new HashMap<>();

    private void initializeMemo(){
        memo.put(0, 0L);
        memo.put(1, 1L);
        for(int i=2;i<=n;i++){
            memo.put(i, -1L);
        }
    }

    public void testFiboPP(){
        initializeMemo();
        long start = System.currentTimeMillis();
        Fibonacci fib = new Fibonacci(n, memo);
        long res = fib.compute();
        long end = System.currentTimeMillis()-start;
        System.out.printf("Fibonacci for %d is %d, and parallel execution took %d ms\n",n,res,end);
//        Fibonacci parallel takes 144269 fon n = 50 before enhancement 1
    }

    public void testFiboSeq(){
        initializeMemo();
        long start = System.currentTimeMillis();
        Fibonacci fib = new Fibonacci(n, memo);
        long res = fib.computeSeq();
        long end = System.currentTimeMillis()-start;
        System.out.printf("Fibonacci for %d is %d, and sequential execution took %d ms\n",n,res,end);
        //Fibonacci Sequential takes 86495 fon n = 50 before enhancement 1
    }
}
