package hiast.hw.question1;

import junit.framework.TestCase;
import hiast.hw.question1.ArrayOccurrencesCount;
import java.util.Random;
import java.util.concurrent.ForkJoinPool;
import java.util.stream.IntStream;

public class ArrayOccurrencesCountTest extends TestCase {

    private int[] randomArray(int size) {
        Random rand = new Random();
        int[] arr = new int[size];
        for (int i = 0; i < size; i++) {
            arr[i] = rand.nextInt(100000);
        }
        return arr;
    }

    private int[] intStream(int size) {
        IntStream intStream = IntStream.range(1, size);
        return intStream.toArray();
    }

    public void testArrayOccurrencesCountSeq() {

//        int size = 1000_000_000;
        int size = 100000000;

        int target = 5;

//        int[] arr = randomArray(size);
        int[] arr = intStream(size);

        ArrayOccurrencesCount array = new ArrayOccurrencesCount(arr, 0, arr.length - 1, target);
        long start = System.currentTimeMillis();
        long occurrences = array.computeSeq();
        long endTimer = System.currentTimeMillis() - start;
        System.out.printf("Sequential Time execution for Random Array of size %d is %d ms number of occurrences is %d\n", size, endTimer, occurrences);
    }

    public void testArrayOccurrencesCountPP() {
        System.setProperty("java.util.concurrent.ForkJoinPool.common.parallelism","7");

//        int size = 1000_000_000;
        int size = 100000000;
//        int[] arr = randomArray(size);
        int[] arr = intStream(size);

        int target = 5;

        ArrayOccurrencesCount occurrences = new ArrayOccurrencesCount(arr, 0, arr.length - 1, target);
        long start = System.currentTimeMillis();
        ForkJoinPool.commonPool().invoke(occurrences);
        long endTimer = System.currentTimeMillis() - start;
        System.out.printf("Parallel Time execution for Random Array of size %d is %d ms sum is %d\n", size, endTimer, occurrences.occurrences);
    }

    public void testArrayOccurrencesCountStreamSeq() {
        System.setProperty("java.util.concurrent.ForkJoinPool.common.parallelism","7");

//        int size = 1000_000_000;
        int size = 100000000;
//        int[] arr = randomArray(size);
        int[] arr = intStream(size);

        int target = 5;

        ArrayOccurrencesCount occurrences = new ArrayOccurrencesCount(arr, 0, arr.length - 1, target);
        long start = System.currentTimeMillis();
        occurrences.computeStreamSeq();
        long endTimer = System.currentTimeMillis() - start;
        System.out.printf("Parallel Stream Time execution for Random Array of size %d is %d ms sum is %d\n", size, endTimer, occurrences.occurrences);
    }

    public void testArrayOccurrencesCountStreamPP() {
        System.setProperty("java.util.concurrent.ForkJoinPool.common.parallelism","7");

//        int size = 1000_000_000;
        int size = 100000000;
//        int[] arr = randomArray(size);
        int[] arr = intStream(size);

        int target = 5;

        ArrayOccurrencesCount occurrences = new ArrayOccurrencesCount(arr, 0, arr.length - 1, target);
        long start = System.currentTimeMillis();
        occurrences.computeStreamPP();
        long endTimer = System.currentTimeMillis() - start;
        System.out.printf("Parallel Stream Time execution for Random Array of size %d is %d ms sum is %d\n", size, endTimer, occurrences.occurrences);
    }

}
