package hiast.hw.question1;

import java.util.Arrays;
import java.util.concurrent.RecursiveAction;

public class ArrayOccurrencesCount extends RecursiveAction {

    public long occurrences;
    int arr[], lo, hi;

    int targetElement;

    public ArrayOccurrencesCount(int[] arr, int lo, int hi, int targetElement) {
        this.arr = arr;
        this.lo = lo;
        this.hi = hi;
        this.targetElement = targetElement;
    }

    public long computeSeq(){
        for (int i = lo; i <= hi; ++i) {
            if(arr[i] == targetElement) occurrences++;
        }
        return occurrences;
    }

    @Override
    protected void compute() {
        if (hi - lo > 1_000_000) {
            int mid = (lo + hi) / 2;
            ArrayOccurrencesCount left = new ArrayOccurrencesCount(arr, lo, mid, targetElement);
            ArrayOccurrencesCount right = new ArrayOccurrencesCount(arr, mid + 1, hi, targetElement);
            left.fork();
            right.compute();
            left.join();
            occurrences = left.occurrences + right.occurrences;
        } else {
            occurrences =computeSeq();
        }
    }

    public void computeStreamSeq() {
        occurrences = Arrays.stream(arr).asLongStream().reduce(0, (acc, elm) -> acc + (elm == targetElement ? 1 : 0));
    }

    public void computeStreamPP() {
        occurrences = Arrays.stream(arr).asLongStream().parallel().reduce(0, (acc, elm) -> acc + (elm == targetElement ? 1 : 0));
    }
}
