package hiast.hw.question3;

import java.util.HashMap;
import java.util.concurrent.RecursiveTask;


/*
However, besides being a dumb way to compute Fibonacci functions (there is a simple fast linear algorithm that you'd use in practice),
 this is likely to perform poorly because the smallest subtasks are too small to be worthwhile splitting up.
 Instead, as is the case for nearly all fork/join applications,
 you'd pick some minimum granularity size (for example 10 here) for which you always sequentially solve rather than subdividing.
 */

public class Fibonacci extends RecursiveTask<Long> {
    final int n;

    final HashMap<Integer, Long> memo;
    public Fibonacci(int n, HashMap<Integer, Long> memo) {
        this.n = n;
        this.memo = memo;
    }

    public Long compute() {

        if(memo.get(n) != -1) return memo.get(n);

        if(n > 20) {
            if (n <= 1)
                return Long.valueOf(n);
            Fibonacci f1 = new Fibonacci(n - 1, memo);
            f1.fork();
            Fibonacci f2 = new Fibonacci(n - 2, memo);
            Long result = f2.compute() + f1.join();
            memo.put(n, result);
        }else{
            Long result = computeSeq();
            memo.put(n, result);
        }
        return memo.get(n);
    }

    public Long computeSeq() {
        if(memo.get(n) != -1) return memo.get(n);

        Fibonacci f1 = new Fibonacci(n - 1, memo);
        Fibonacci f2 = new Fibonacci(n - 2, memo);
        Long result = f2.computeSeq() + f1.computeSeq();
        memo.put(n, result);
        return result;
    }

}
