import junit.framework.TestCase;
import java.util.ArrayList;
import java.util.List;

public class PrimeNumberFinderTest extends TestCase {

    public void testPrimeNumberFinderUsingTHread(){
        long startTime = System.currentTimeMillis();


        PrimeNumberFinderThread[] primeNumberFinderThreads = new PrimeNumberFinderThread[4];
        int[] values = {1, 25000000, 50000000, 75000000, 100000000};
        List<List<Integer>> results = new ArrayList<>();

        for(int i=0;i<4;i++) {
            PrimeNumberFinder finder = new PrimeNumberFinder(values[i], values[i+1]);
            primeNumberFinderThreads[i] = new PrimeNumberFinderThread(finder);
            primeNumberFinderThreads[i].start();
        }
        for(int i=0;i<4;i++) {
            try {
                primeNumberFinderThreads[i].join();
                results.add(primeNumberFinderThreads[i].primes.primeNumbers);
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        long endTime = System.currentTimeMillis();
        System.out.println("Time Taken: " + (endTime - startTime));
        System.out.println(results);
    }
    public void testPrimeNumberFinderUsingTHread2(){
        long startTime = System.currentTimeMillis();


        PrimeNumberFinderThread[] primeNumberFinderThreads = new PrimeNumberFinderThread[8];
        int[] values = {1,12500000 ,25000000,37500000 , 50000000,62500000 ,75000000,87500000, 100000000};
        List<List<Integer>> results = new ArrayList<>();

        for(int i=0;i<8;i++) {
            PrimeNumberFinder finder = new PrimeNumberFinder(values[i], values[i+1]);
            primeNumberFinderThreads[i] = new PrimeNumberFinderThread(finder);
            primeNumberFinderThreads[i].start();
        }
        for(int i=0;i<4;i++) {
            try {
                primeNumberFinderThreads[i].join();
                results.add(primeNumberFinderThreads[i].primes.primeNumbers);
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        long endTime = System.currentTimeMillis();
        System.out.println("Time Taken: " + (endTime - startTime));
        System.out.println(results);
    }

    public void testPrimeNumberFinderUsingTHread3(){
        long startTime = System.currentTimeMillis();


        PrimeNumberFinderThread[] primeNumberFinderThreads = new PrimeNumberFinderThread[4];
        int[] values = {1,12500000 ,25000000,37500000 , 50000000};
        List<List<Integer>> results = new ArrayList<>();

        for(int i=0;i<4;i++) {
            PrimeNumberFinder finder = new PrimeNumberFinder(values[i], values[i+1]);
            primeNumberFinderThreads[i] = new PrimeNumberFinderThread(finder);
            primeNumberFinderThreads[i].start();
        }
        for(int i=0;i<4;i++) {
            try {
                primeNumberFinderThreads[i].join();
                results.add(primeNumberFinderThreads[i].primes.primeNumbers);
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        long endTime = System.currentTimeMillis();
        System.out.println("Time Taken: " + (endTime - startTime));
        System.out.println(results);
    }
    public void testPrimeNumberFinderUsingTHread4(){
        long startTime = System.currentTimeMillis();


        PrimeNumberFinderThread[] primeNumberFinderThreads = new PrimeNumberFinderThread[12];
        int[] values = {1,6250000,12500000 ,18750000,25000000,31250000,37500000, 50000000,56250000,62500000 ,75000000,87500000, 100000000};
        List<List<Integer>> results = new ArrayList<>();

        for(int i=0;i<12;i++) {
            PrimeNumberFinder finder = new PrimeNumberFinder(values[i], values[i+1]);
            primeNumberFinderThreads[i] = new PrimeNumberFinderThread(finder);
            primeNumberFinderThreads[i].start();
        }
        for(int i=0;i<4;i++) {
            try {
                primeNumberFinderThreads[i].join();
                results.add(primeNumberFinderThreads[i].primes.primeNumbers);
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        long endTime = System.currentTimeMillis();
        System.out.println("Time Taken: " + (endTime - startTime));
        System.out.println(results);
    }


}
