import java.util.UUID;
import java.util.ArrayList;
import java.util.List;

public class PrimeNumberFinder {
    protected int start;
    protected int end;
    public List<Integer> primeNumbers;

    public PrimeNumberFinder(int start, int end) {
        primeNumbers = new ArrayList<>();
        this.start = start;
        this.end = end;
    }
    public void findPrimes() {
        for (int num = start; num <= end; num++) {
            if (isPrime(num)) {
                primeNumbers.add(num);
            }
        }
        return;
    }
    private boolean isPrime(int num) {
        if (num <= 1) {
            return false;
        }
        if (num <= 3) {
            return true;
        }
        if (num % 2 == 0 || num % 3 == 0) {
            return false;
        }

        for (int i = 5; i * i <= num; i += 6) {
            if (num % i == 0 || num % (i + 2) == 0) {
                return false;
            }
        }
        return true;
    }
}
