package summers;
import worker.WorkPartitioner;
public class SummerThread extends Thread{
    // Private variables to store the start and finish indices, the data array, and the sum
    private int start;
    private int finish;
    private int[] data;
    private long sum;
    // Constructor taking data, start, and finish indices
    public SummerThread(int[] data, int start, int finish) {
        this.start = start;
        this.finish = finish;
        this.data = data;
    }
    // Constructor taking data and a WorkPartitioner.Part to extract start and finish indices
    public SummerThread(int[] data, WorkPartitioner.Part part) {
        this(data, part.getStart(), part.getFinish());
    }
    // Override the run method from the Thread class
    @Override
    public void run() {
        // Initialize the sum for this thread instance
        sum = 0;
        // Loop through the data within the specified partition and count prime numbers
        for (int i = start; i < finish; i++) {
            if (isPrime(i)) {
                sum++;
            }
        }
    }
    // Private method to check if a number is prime, used in the run method
    private boolean isPrime(int num) {
        if (num <= 1) {
            return false;
        }
        if (num <= 3) {
            return true;
        }
        if (num % 2 == 0 || num % 3 == 0) {
            return false;
        }

        for (int i = 5; i * i <= num; i += 6) {
            if (num % i == 0 || num % (i + 2) == 0) {
                return false;
            }
        }
        return true;
    }
    // Getter method to retrieve the sum
    public long getSum() {
        return sum;
    }

}