package summers;
import worker.WorkPartitioner;

public class SummerRunnable extends Summer implements Runnable{
    // Private variable to store the thread associated with this runnable
    private Thread thread;
    // Constructor taking data and a WorkPartitioner.Part to extract start and finish indices
    public SummerRunnable(int[] data, WorkPartitioner.Part part) {
        super(data, part);
    }
    // Override the run method from the Runnable interface
    @Override
    public void run() {
        sum = 0;
        // Loop through the data within the specified partition and count prime numbers
        for (int i = start; i < finish; i++) {
            if (isPrime(i)) {
                sum++;
            }
        }
    }
    // Method to start the associated thread
    public void startThread() {
        thread =  new Thread(this);
        thread.start();
    }
    // Method to wait for the associated thread to finish
    public void joinThread() throws InterruptedException {
        thread.join();
    }
    // Private method to check if a number is prime, used in the run method
    private boolean isPrime(int num) {
        if (num <= 1) {
            return false;
        }
        if (num <= 3) {
            return true;
        }
        if (num % 2 == 0 || num % 3 == 0) {
            return false;
        }

        for (int i = 5; i * i <= num; i += 6) {
            if (num % i == 0 || num % (i + 2) == 0) {
                return false;
            }
        }
        return true;
    }
}