package summers;
import worker.WorkPartitioner;

import java.util.concurrent.Callable;

public class SummerCallable extends Summer implements Callable<Long> {
    // Constructor taking data and a WorkPartitioner.Part to extract start and finish indices
    public SummerCallable(int[] data, WorkPartitioner.Part part) {

        super(data, part);
    }
    // Override the call method from Callable interface
    @Override
    public Long call() throws Exception {
        // Initialize the sum for this callable instance
        this.sum = 0;
        // Loop through the data within the specified partition and count prime numbers
        for (int i = start; i < finish; i++) {
            if (isPrime(i)) {
                sum++;
            }
        }
        // Return the sum calculated by this callable instance
        return sum;
    }
    // Private method to check if a number is prime, used in the call method
    private boolean isPrime(int num) {
        if (num <= 1) {
            return false;
        }
        if (num <= 3) {
            return true;
        }
        if (num % 2 == 0 || num % 3 == 0) {
            return false;
        }

        for (int i = 5; i * i <= num; i += 6) {
            if (num % i == 0 || num % (i + 2) == 0) {
                return false;
            }
        }
        return true;
    }
}