package parallelsummers;
import summers.SummerCallable;
import worker.WorkPartitioner;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
public class ParallelSummer4{
    public static long sum(int[] data, int threadCount) {
        // Create a fixed thread pool with the specified thread count
        ExecutorService executor = Executors.newFixedThreadPool(threadCount);
        // List to store Future objects for parallel processing
        List<Future<Long>> results = new ArrayList<Future<Long>>();
        // List to store work partitions for each thread
        List<WorkPartitioner.Part> parts =  WorkPartitioner.partitions(data.length, threadCount);
        // Submit SummerCallable tasks to the executor and store the Future objects
        for (WorkPartitioner.Part part : parts) {
            results.add(executor.submit(new SummerCallable(data, part)));
        }
        // Shutdown the executor to no longer accept new tasks
        executor.shutdown();
        // Wait for all submitted tasks to complete
        while (!executor.isTerminated()) {
        }
        // Calculate the total sum by summing up individual thread sums
        long sum = 0;
        for (Future<Long> future : results) {
            try {
                // Retrieve and add the result from each thread
                sum += future.get();
            } catch (InterruptedException | ExecutionException e) {
                System.err.println("Cannot get the results from threads.");
                return -2;
            }
        }
        // Return the final sum calculated in parallel
        return sum;
    }
}
